import flixel.text.FlxTextFormat;
public var camMain = new FlxCamera(0, 0, 960, 720);
FlxG.cameras.add(camMain, false);
camMain.bgColor = -1;

public var redSquare = new FlxSprite(0, 0).makeGraphic(1, 1, FlxColor.RED);
public var blueSquare = new FlxSprite(0, 0).makeGraphic(1, 1, FlxColor.BLUE);
public var rick:FlxSprite = new FlxSprite();
rick.frames = Paths.getFrames("characters/rickastley");
rick.animation.addByPrefix("bop", "rickastley rickastley", 24, false);
rick.scale.set(3,3);
rick.updateHitbox();

public var mainTxt:FlxText;
var slideAmount = 0;

window.title = "tmpRkRL85";

function create() {
	FlxG.cameras.remove(camGame, false);
	FlxG.cameras.remove(camHUD, false);
	FlxG.cameras.add(camHUD, false);
	GameOverSubstate.script = 'data/scripts/gameovers/aqua';
}
function postCreate() {
    trace("h");
	redSquare.cameras = [camMain];
	redReset();
	blueSquare.cameras = [camMain];
	blueReset();
	add(blueSquare);
	add(redSquare);
	
	rick.cameras = [camMain];
	add(rick);
	
	mainTxt = new FlxText(20, 650, 0, PlayState.SONG.meta.name + '.flv - slide ');
	slideTxt = new FlxText(20, 650, 0, '0000');
	for (txt in [mainTxt]) {
	txt.setFormat(Paths.font('cour.ttf'), 28, FlxColor.BLACK);
	txt.cameras = [camMain];
	add(txt);
	}
	slideTxt.x = mainTxt.x + 323;
	
	
	for (i in [PlayState.instance.healthBar,
		PlayState.instance.healthBarBG,
		PlayState.instance.iconP1,
		PlayState.instance.iconP2,
		PlayState.instance.scoreTxt,
		PlayState.instance.accuracyTxt,
		PlayState.instance.missesTxt]) i.visible = false;
	newRatingsRVisible = false;
}

//"characters"
function redReset () {
	
	redSquare.scale.x = FlxG.random.int(20, 800);
	redSquare.scale.y = FlxG.random.int(20, 800);
    redSquare.y = FlxG.random.int(0, camMain.height-redSquare.height);
	redSquare.x = FlxG.random.int(0, camMain.width-redSquare.width);
}
function blueReset () {
	blueSquare.scale.x = FlxG.random.int(20, 800);
	blueSquare.scale.y = FlxG.random.int(20, 800);
    blueSquare.y = FlxG.random.int(0, camMain.height-redSquare.height);
	blueSquare.x = FlxG.random.int(0, camMain.width-redSquare.width);
}

function rickSwitch() {
	rick.animation.play('bop', true);
	rick.x = FlxG.random.int(-150, 150);
	if (rick.flipX) rick.flipX = false; else rick.flipX = true;
	rick.animation.finishCallback = function (name:String)
    if(name == 'bop')
	rickSwitch();
	//trace("flip");
}

function onNoteHit(event) {
	if (event.character == strumLines.members[0].characters[0]) 
		if (!event.note.isSustainNote) {
			redReset();
			slideAmount += 1;
			rickSwitch();
		}
	if (event.character == strumLines.members[1].characters[0])
		if (!event.note.isSustainNote) {blueReset(); slideAmount += 1;}
	event.showSplash = false;
}

function onPlayerMiss(event:NoteHitEvent)
	{
		slideAmount -= 10;
		if (slideAmount <= 0) health = -1;
		else health = 1;

	}

public var slidesActive = true;
function update(elapsed) {
	
	if (slideTxt != null) slideTxt.text = slideAmount;
	switch (slideTxt.text.length)
	{
		case 1: slideTxt.text = "000" + slideTxt.text;
		case 2: slideTxt.text = "00" + slideTxt.text;
		case 3: slideTxt.text = "0" + slideTxt.text;
	}
	if (slidesActive) mainTxt.text = PlayState.SONG.meta.name + '.flv - slide '+slideTxt.text;
	
}
function postUpdate() camZooming = false;

//notes
function onNoteCreation(event) {

	event.cancel();

	var note = event.note;
	if (event.note.isSustainNote) {
		note.loadGraphic(Paths.image('game/notes/torso/arrowEnds'), true, 28, 24);
		note.animation.add("hold", [event.strumID]);
		note.animation.add("holdend", [4 + event.strumID]);
	} else {
		note.loadGraphic(Paths.image('game/notes/torso/arrows'), true, 68, 68);
		note.animation.add("scroll", [4 + event.strumID]);
	}
	note.scale.set(1.5, 1.5);
	note.updateHitbox();
}
function onPostNoteCreation(event) if (event.note.isSustainNote) event.note.alpha = 1;

function onStrumCreation(event) {

	event.cancel();

	var strum = event.strum;
	strum.loadGraphic(Paths.image('game/notes/torso/arrows'), true, 68, 68);
	strum.animation.add("static", [event.strumID]);
	strum.animation.add("pressed", [4 + event.strumID, 8 + event.strumID], 12, false);
	strum.animation.add("confirm", [12 + event.strumID, 16 + event.strumID], 24, false);

	strum.scale.set(1.5, 1.5);
	strum.updateHitbox();
}